'===============================================================================
' Copyright  Micromega Corporation 2004-2008. All rights reserved.
'
' @file   graph-demo3.bs2
' @target PICAXE
'
' This demo draws the cosine function and a multiplier function.
'
' See Application Note 42 - Drawing Graphs on a Serial Graphic Display
'
' @author Cam Thompson, Micromega Corporation
' @version
'   May 9, 2008
'   - original version
'
'===============================================================================

'===============================================================================
'-------------------- uM-FPU V3.1 I2C definitions ------------------- 2007-07-11
'===============================================================================

symbol	fpuID		= 0xC8	' uM-FPU I2C address

;-------------------- uM-FPU V3 opcode definitions -----------------------------

symbol	NOP		= 0x00	' No Operation
symbol	SELECTA	= 0x01	' Select register A
symbol	SELECTX	= 0x02	' Select register X
symbol	CLR		= 0x03	' reg[nn] = 0
symbol	CLRA		= 0x04	' reg[A] = 0
symbol	CLRX		= 0x05	' reg[X] = 0, X = X + 1
symbol	CLR0		= 0x06	' reg[0] = 0
symbol	COPY		= 0x07	' reg[nn] = reg[mm]
symbol	COPYA		= 0x08	' reg[nn] = reg[A]
symbol	COPYX		= 0x09	' reg[nn] = reg[X], X = X + 1
symbol	LOAD		= 0x0A	' reg[0] = reg[nn]
symbol	LOADA		= 0x0B	' reg[0] = reg[A]
symbol	LOADX		= 0x0C	' reg[0] = reg[X], X = X + 1
symbol	ALOADX	= 0x0D	' reg[A] = reg[X], X = X + 1
symbol	XSAVE		= 0x0E	' reg[X] = reg[nn], X = X + 1
symbol	XSAVEA	= 0x0F	' reg[X] = reg[A], X = X + 1
symbol	COPY0		= 0x10	' reg[nn] = reg[0]
symbol	COPYI		= 0x11	' reg[nn] = long(unsigned bb)
symbol	SWAP		= 0x12	' Swap reg[nn] and reg[mm]
symbol	SWAPA		= 0x13	' Swap reg[A] and reg[nn]
symbol	LEFT		= 0x14	' Left parenthesis
symbol	RIGHT		= 0x15	' Right parenthesis
symbol	FWRITE	= 0x16	' Write 32-bit float to reg[nn]
symbol	FWRITEA	= 0x17	' Write 32-bit float to reg[A]
symbol	FWRITEX	= 0x18	' Write 32-bit float to reg[X], X = X + 1
symbol	FWRITE0	= 0x19	' Write 32-bit float to reg[0]
symbol	FREAD		= 0x1A	' Read 32-bit float from reg[nn]
symbol	FREADA	= 0x1B	' Read 32-bit float from reg[A]
symbol	FREADX	= 0x1C	' Read 32-bit float from reg[X], X = X + 1
symbol	FREAD0	= 0x1D	' Read 32-bit float from reg[0]
symbol	ATOF		= 0x1E	' Convert ASCII to float, store in reg[0]
symbol	FTOA		= 0x1F	' Convert float to ASCII
symbol	FSET		= 0x20	' reg[A] = reg[nn]
symbol	FADD		= 0x21	' reg[A] = reg[A] + reg[nn]
symbol	FSUB		= 0x22	' reg[A] = reg[A] - reg[nn]
symbol	FSUBR		= 0x23	' reg[A] = reg[nn] - reg[A]
symbol	FMUL		= 0x24	' reg[A] = reg[A] * reg[nn]
symbol	FDIV		= 0x25	' reg[A] = reg[A] / reg[nn]
symbol	FDIVR		= 0x26	' reg[A] = reg[nn] / reg[A]
symbol	FPOW		= 0x27	' reg[A] = reg[A] ** reg[nn]
symbol	FCMP		= 0x28	' Float compare reg[A] - reg[nn]
symbol	FSET0		= 0x29	' reg[A] = reg[0]
symbol	FADD0		= 0x2A	' reg[A] = reg[A] + reg[0]
symbol	FSUB0		= 0x2B	' reg[A] = reg[A] - reg[0]
symbol	FSUBR0	= 0x2C	' reg[A] = reg[0] - reg[A]
symbol	FMUL0		= 0x2D	' reg[A] = reg[A] * reg[0]
symbol	FDIV0		= 0x2E	' reg[A] = reg[A] / reg[0]
symbol	FDIVR0	= 0x2F	' reg[A] = reg[0] / reg[A]
symbol	FPOW0		= 0x30	' reg[A] = reg[A] ** reg[0]
symbol	FCMP0		= 0x31	' Float compare reg[A] - reg[0]
symbol	FSETI		= 0x32	' reg[A] = float(bb)
symbol	FADDI		= 0x33	' reg[A] = reg[A] + float(bb)
symbol	FSUBI		= 0x34	' reg[A] = reg[A] - float(bb)
symbol	FSUBRI	= 0x35	' reg[A] = float(bb) - reg[A]
symbol	FMULI		= 0x36	' reg[A] = reg[A] * float(bb)
symbol	FDIVI		= 0x37	' reg[A] = reg[A] / float(bb)
symbol	FDIVRI	= 0x38	' reg[A] = float(bb) / reg[A]
symbol	FPOWI		= 0x39	' reg[A] = reg[A] ** bb
symbol	FCMPI		= 0x3A	' Float compare reg[A] - float(bb)
symbol	FSTATUS	= 0x3B	' Float status of reg[nn]
symbol	FSTATUSA	= 0x3C	' Float status of reg[A]
symbol	FCMP2		= 0x3D	' Float compare reg[nn] - reg[mm]
symbol	FNEG		= 0x3E	' reg[A] = -reg[A]
symbol	FABS		= 0x3F	' reg[A] = | reg[A] |
symbol	FINV		= 0x40	' reg[A] = 1 / reg[A]
symbol	SQRT		= 0x41	' reg[A] = sqrt(reg[A])
symbol	ROOT		= 0x42	' reg[A] = root(reg[A], reg[nn])
symbol	LOG		= 0x43	' reg[A] = log(reg[A])
symbol	LOG10		= 0x44	' reg[A] = log10(reg[A])
symbol	EXP		= 0x45	' reg[A] = exp(reg[A])
symbol	EXP10		= 0x46	' reg[A] = exp10(reg[A])
symbol	SIN		= 0x47	' reg[A] = sin(reg[A])
symbol	COS		= 0x48	' reg[A] = cos(reg[A])
symbol	TAN		= 0x49	' reg[A] = tan(reg[A])
symbol	ASIN		= 0x4A	' reg[A] = asin(reg[A])
symbol	ACOS		= 0x4B	' reg[A] = acos(reg[A])
symbol	ATAN		= 0x4C	' reg[A] = atan(reg[A])
symbol	ATAN2		= 0x4D	' reg[A] = atan2(reg[A], reg[nn])
symbol	DEGREES	= 0x4E	' reg[A] = degrees(reg[A])
symbol	RADIANS	= 0x4F	' reg[A] = radians(reg[A])
symbol	FMOD		= 0x50	' reg[A] = reg[A] MOD reg[nn]
symbol	FLOOR		= 0x51	' reg[A] = floor(reg[A])
symbol	CEIL		= 0x52	' reg[A] = ceil(reg[A])
symbol	ROUND		= 0x53	' reg[A] = round(reg[A])
symbol	FMIN		= 0x54	' reg[A] = min(reg[A], reg[nn])
symbol	FMAX		= 0x55	' reg[A] = max(reg[A], reg[nn])
symbol	FCNV		= 0x56	' reg[A] = conversion(nn, reg[A])
symbol	FMAC		= 0x57	' reg[A] = reg[A] + (reg[nn] * reg[mm])
symbol	FMSC		= 0x58	' reg[A] = reg[A] - (reg[nn] * reg[mm])
symbol	LOADBYTE	= 0x59	' reg[0] = float(signed bb)
symbol	LOADUBYTE	= 0x5A	' reg[0] = float(unsigned byte)
symbol	LOADWORD	= 0x5B	' reg[0] = float(signed word)
symbol	LOADUWORD	= 0x5C	' reg[0] = float(unsigned word)
symbol	LOADE		= 0x5D	' reg[0] = 2.7182818
symbol	LOADPI	= 0x5E	' reg[0] = 3.1415927
symbol	LOADCON	= 0x5F	' reg[0] = float constant(nn)
symbol	FLOAT		= 0x60	' reg[A] = float(reg[A])
symbol	FIX		= 0x61	' reg[A] = fix(reg[A])
symbol	FIXR		= 0x62	' reg[A] = fix(round(reg[A]))
symbol	FRAC		= 0x63	' reg[A] = fraction(reg[A])
symbol	FSPLIT	= 0x64	' reg[A] = int(reg[A]), reg[0] = frac(reg[A])
symbol	SELECTMA	= 0x65	' Select matrix A
symbol	SELECTMB	= 0x66	' Select matrix B
symbol	SELECTMC	= 0x67	' Select matrix C
symbol	LOADMA	= 0x68	' reg[0] = matrix A[bb,bb]
symbol	LOADMB	= 0x69	' reg[0] = matrix B[bb, bb]
symbol	LOADMC	= 0x6A	' reg[0] = matrix C[bb, bb]
symbol	SAVEMA	= 0x6B	' matrix A[bb,bb] = reg[A]
symbol	SAVEMB	= 0x6C	' matrix B[bb,bb] = reg[A]
symbol	SAVEMC	= 0x6D	' matrix C[bb,bb] = reg[A]
symbol	MOP		= 0x6E	' Matrix operation
symbol	FFT		= 0x6F	' FFT operation
symbol	WRBLK		= 0x70	' Write register block
symbol	RDBLK		= 0x71	' Read register block
symbol	LOADIND	= 0x7A	' reg[0] = reg[reg[nn]]
symbol	SAVEIND	= 0x7B	' reg[reg[nn]] = reg[A]
symbol	INDA		= 0x7C	' Select A using reg[nn]
symbol	INDX		= 0x7D	' Select X using reg[nn]
symbol	FCALL		= 0x7E	' Call user-defined function in Flash memory
symbol	EECALL	= 0x7F	' Call user-defined function in EEPROM memory
symbol	RET		= 0x80	' Return from user-defined function
symbol	BRA		= 0x81	' Unconditional branch
symbol	BRACC		= 0x82	' Conditional branch
symbol	JMP		= 0x83	' Unconditional jump
symbol	JMPCC		= 0x84	' Conditional jump
symbol	TABLE		= 0x85	' Table lookup
symbol	FTABLE	= 0x86	' Floating point reverse table lookup
symbol	LTABLE	= 0x87	' Long integer reverse table lookup
symbol	POLY		= 0x88	' reg[A] = nth order polynomial
symbol	FGOTO		= 0x89	' Computed goto
symbol	RETCC		= 0x8A	' Conditional return from function
symbol	LWRITE	= 0x90	' Write 32-bit long integer to reg[nn]
symbol	LWRITEA	= 0x91	' Write 32-bit long integer to reg[A]
symbol	LWRITEX	= 0x92	' Write 32-bit long integer to reg[X], X = X + 1
symbol	LWRITE0	= 0x93	' Write 32-bit long integer to reg[0]
symbol	LREAD		= 0x94	' Read 32-bit long integer from reg[nn]
symbol	LREADA	= 0x95	' Read 32-bit long integer from reg[A]
symbol	LREADX	= 0x96	' Read 32-bit long integer from reg[X], X = X + 1
symbol	LREAD0	= 0x97	' Read 32-bit long integer from reg[0]
symbol	LREADBYTE	= 0x98	' Read lower 8 bits of reg[A]
symbol	LREADWORD	= 0x99	' Read lower 16 bits reg[A]
symbol	ATOL		= 0x9A	' Convert ASCII to long integer
symbol	LTOA		= 0x9B	' Convert long integer to ASCII
symbol	LSET		= 0x9C	' reg[A] = reg[nn]
symbol	LADD		= 0x9D	' reg[A] = reg[A] + reg[nn]
symbol	LSUB		= 0x9E	' reg[A] = reg[A] - reg[nn]
symbol	LMUL		= 0x9F	' reg[A] = reg[A] * reg[nn]
symbol	LDIV		= 0xA0	' reg[A] = reg[A] / reg[nn]
symbol	LCMP		= 0xA1	' Signed long compare reg[A] - reg[nn]
symbol	LUDIV		= 0xA2	' reg[A] = reg[A] / reg[nn]
symbol	LUCMP		= 0xA3	' Unsigned long compare of reg[A] - reg[nn]
symbol	LTST		= 0xA4	' Long integer status of reg[A] AND reg[nn] 
symbol	LSET0		= 0xA5	' reg[A] = reg[0]
symbol	LADD0		= 0xA6	' reg[A] = reg[A] + reg[0]
symbol	LSUB0		= 0xA7	' reg[A] = reg[A] - reg[0]
symbol	LMUL0		= 0xA8	' reg[A] = reg[A] * reg[0]
symbol	LDIV0		= 0xA9	' reg[A] = reg[A] / reg[0]
symbol	LCMP0		= 0xAA	' Signed long compare reg[A] - reg[0]
symbol	LUDIV0	= 0xAB	' reg[A] = reg[A] / reg[0]
symbol	LUCMP0	= 0xAC	' Unsigned long compare reg[A] - reg[0]
symbol	LTST0		= 0xAD	' Long integer status of reg[A] AND reg[0] 
symbol	LSETI		= 0xAE	' reg[A] = long(bb)
symbol	LADDI		= 0xAF	' reg[A] = reg[A] + long(bb)
symbol	LSUBI		= 0xB0	' reg[A] = reg[A] - long(bb)
symbol	LMULI		= 0xB1	' reg[A] = reg[A] * long(bb)
symbol	LDIVI		= 0xB2	' reg[A] = reg[A] / long(bb)
symbol	LCMPI		= 0xB3	' Signed long compare reg[A] - long(bb)
symbol	LUDIVI	= 0xB4	' reg[A] = reg[A] / unsigned long(bb)
symbol	LUCMPI	= 0xB5	' Unsigned long compare reg[A] - ulong(bb)
symbol	LTSTI		= 0xB6	' Long integer status of reg[A] AND ulong(bb)
symbol	LSTATUS	= 0xB7	' Long integer status of reg[nn]
symbol	LSTATUSA	= 0xB8	' Long integer status of reg[A]
symbol	LCMP2		= 0xB9	' Signed long compare reg[nn] - reg[mm]
symbol	LUCMP2	= 0xBA	' Unsigned long compare reg[nn] - reg[mm]
symbol	LNEG		= 0xBB	' reg[A] = -reg[A]
symbol	LABS		= 0xBC	' reg[A] = | reg[A] |
symbol	LINC		= 0xBD	' reg[nn] = reg[nn] + 1
symbol	LDEC		= 0xBE	' reg[nn] = reg[nn] - 1
symbol	LNOT		= 0xBF	' reg[A] = NOT reg[A]
symbol	LAND		= 0xC0	' reg[A] = reg[A] AND reg[nn]
symbol	LOR		= 0xC1	' reg[A] = reg[A] OR reg[nn]
symbol	LXOR		= 0xC2	' reg[A] = reg[A] XOR reg[nn]
symbol	LSHIFT	= 0xC3	' reg[A] = reg[A] shift reg[nn]
symbol	LMIN		= 0xC4	' reg[A] = min(reg[A], reg[nn])
symbol	LMAX		= 0xC5	' reg[A] = max(reg[A], reg[nn])
symbol	LONGBYTE	= 0xC6	' reg[0] = long(signed byte bb)
symbol	LONGUBYTE	= 0xC7	' reg[0] = long(unsigned byte bb)
symbol	LONGWORD	= 0xC8	' reg[0] = long(signed word wwww)
symbol	LONGUWORD	= 0xC9	' reg[0] = long(unsigned word wwww)
symbol	SETSTATUS	= 0xCD	' Set status byte
symbol	FSEROUT	= 0xCE	' Serial output
symbol	FSERIN	= 0xCF	' Serial Input
symbol	SETOUT	= 0xD0	' Set OUT1 and OUT2 output pins
symbol	ADCMODE	= 0xD1	' Set A/D trigger mode
symbol	ADCTRIG	= 0xD2	' A/D manual trigger
symbol	ADCSCALE	= 0xD3	' ADCscale[ch] = B
symbol	ADCLONG	= 0xD4	' reg[0] = ADCvalue[ch]
symbol	ADCLOAD	= 0xD5	' reg[0] = float(ADCvalue[ch]) * ADCscale[ch]
symbol	ADCWAIT	= 0xD6	' wait for next A/D sample
symbol	TIMESET	= 0xD7	' time = reg[0]
symbol	TIMELONG	= 0xD8	' reg[0] = time (long)
symbol	TICKLONG	= 0xD9	' reg[0] = ticks (long)
symbol	EESAVE	= 0xDA	' EEPROM[nn] = reg[mm]
symbol	EESAVEA	= 0xDB	' EEPROM[nn] = reg[A]
symbol	EELOAD	= 0xDC	' reg[nn] = EEPROM[mm]
symbol	EELOADA	= 0xDD	' reg[A] = EEPROM[nn]
symbol	EEWRITE	= 0xDE	' Store bytes in EEPROM
symbol	EXTSET	= 0xE0	' external input count = reg[0]
symbol	EXTLONG	= 0xE1	' reg[0] = external input counter (long)
symbol	EXTWAIT	= 0xE2	' Wait for next external input
symbol	STRSET	= 0xE3	' Copy string to string buffer
symbol	STRSEL	= 0xE4	' Set selection point
symbol	STRINS	= 0xE5	' Insert string at selection point
symbol	STRCMP	= 0xE6	' Compare string with string buffer
symbol	STRFIND	= 0xE7	' Find string and set selection point
symbol	STRFCHR	= 0xE8	' Set field separators
symbol	STRFIELD	= 0xE9	' Find field and set selection point
symbol	STRTOF	= 0xEA	' Convert string selection to float
symbol	STRTOL	= 0xEB	' Convert string selection to long
symbol	READSEL	= 0xEC	' Read string selection
symbol	STRBYTE	= 0xED	' Insert 8-bit byte at selection point
symbol	STRINC	= 0xEE	' Increment selection point
symbol	STRDEC	= 0xEF	' Decrement selection point

symbol	SYNC		= 0xF0	' Get synchronization byte
symbol	READSTATUS	= 0xF1	' Read status byte
symbol	READSTR	= 0xF2	' Read string from string buffer
symbol	VERSION	= 0xF3	' Copy version string to string buffer
symbol	IEEEMODE	= 0xF4	' Set IEEE mode (default)
symbol	PICMODE	= 0xF5	' Set PIC mode
symbol	CHECKSUM	= 0xF6	' Calculate checksum for uM-FPU code
symbol	BREAK		= 0xF7	' Debug breakpoint
symbol	TRACEOFF	= 0xF8	' Turn debug trace off
symbol	TRACEON	= 0xF9	' Turn debug trace on
symbol	TRACESTR	= 0xFA	' Send string to debug trace buffer
symbol	TRACEREG	= 0xFB	' Send register value to trace buffer
symbol	READVAR	= 0xFC	' Read internal variable, store in reg[0]

symbol	SYNC_CHAR	= 0x5C	' sync character

'-------------------- uM-FPU variables -----------------------------------------

symbol	dataByte	= b13		' data byte
symbol	format	= b13		' format (same as dataByte)
symbol	statusByte	= b13		' status byte (same as dataByte)

'-------------------- uM-FPU status bits ---------------------------------------

symbol	IS_ZERO	= 0x81	' positive zero
symbol	IS_NZERO	= 0x83	' negative zero
symbol	IS_NEGATIVE	= 0x82	' negative
symbol	IS_NAN	= 0x84	' NaN (Not-a-Number)
symbol	IS_PINF	= 0x88	' positive infinity
symbol	IS_NINF	= 0x8A	' negative infinity

'==================== end of uM-FPU V3.1 I2C definitions =======================

'-------------------- uM-FPU Register Definitions -----------------------------
symbol reg0             = 0             ' uM-FPU register 0
symbol reg1             = 1             ' uM-FPU register 1
symbol reg2             = 2             ' uM-FPU register 2
symbol reg3             = 3             ' uM-FPU register 3
symbol reg4             = 4             ' uM-FPU register 4
symbol tmp1             = 1             ' uM-FPU register 1
symbol tmp2             = 2             ' uM-FPU register 2
symbol tmp3             = 3             ' uM-FPU register 3
symbol n1               = 4             ' uM-FPU register 4
symbol n2               = 5             ' uM-FPU register 5
symbol xval             = 6             ' uM-FPU register 6
symbol yval             = 7             ' uM-FPU register 7
symbol ptr              = 8             ' uM-FPU register 8
symbol cnt              = 9             ' uM-FPU register 9
symbol formatX          = 10            ' uM-FPU register 10
symbol formatY          = 11            ' uM-FPU register 11
symbol fillColor        = 12            ' uM-FPU register 12
symbol axisColor        = 13            ' uM-FPU register 13
symbol dataColor        = 14            ' uM-FPU register 14
symbol gxWinMin         = 15            ' uM-FPU register 15
symbol gyWinMin         = 16            ' uM-FPU register 16
symbol gxWinMax         = 17            ' uM-FPU register 17
symbol gyWinMax         = 18            ' uM-FPU register 18
symbol gxMin1           = 19            ' uM-FPU register 19
symbol gyMin1           = 20            ' uM-FPU register 20
symbol gxMax1           = 21            ' uM-FPU register 21
symbol gyMax1           = 22            ' uM-FPU register 22
symbol gxMin2           = 23            ' uM-FPU register 23
symbol gyMin2           = 24            ' uM-FPU register 24
symbol gxMax2           = 25            ' uM-FPU register 25
symbol gyMax2           = 26            ' uM-FPU register 26
symbol gxMin            = 27            ' uM-FPU register 27
symbol gyMin            = 28            ' uM-FPU register 28
symbol gxMax            = 29            ' uM-FPU register 29
symbol gyMax            = 30            ' uM-FPU register 30
symbol gx1              = 31            ' uM-FPU register 31
symbol gy1              = 32            ' uM-FPU register 32
symbol gx2              = 33            ' uM-FPU register 33
symbol gy2              = 34            ' uM-FPU register 34
symbol gxAxis           = 35            ' uM-FPU register 35
symbol gyAxis           = 36            ' uM-FPU register 36
symbol nx               = 37            ' uM-FPU register 37
symbol xUnits           = 38            ' uM-FPU register 38
symbol xOffset          = 39            ' uM-FPU register 39
symbol xScale           = 40            ' uM-FPU register 40
symbol xTick            = 41            ' uM-FPU register 41
symbol gxTick           = 42            ' uM-FPU register 42
symbol gxLast           = 43            ' uM-FPU register 43
symbol xval0            = 44            ' uM-FPU register 44
symbol ny               = 45            ' uM-FPU register 45
symbol yMin             = 46            ' uM-FPU register 46
symbol yMax             = 47            ' uM-FPU register 47
symbol yTick            = 48            ' uM-FPU register 48
symbol yRange           = 49            ' uM-FPU register 49
symbol gyRange          = 50            ' uM-FPU register 50
symbol gyLast           = 51            ' uM-FPU register 51
symbol minVal           = 59            ' uM-FPU register 59
symbol maxVal           = 60            ' uM-FPU register 60
symbol nPoints          = 61            ' uM-FPU register 61
symbol maxPoints        = 62            ' uM-FPU register 62
symbol pointArray       = 63            ' uM-FPU register 63

'-------------------- uM-FPU Function Definitions -----------------------------
symbol getID            = 0             ' uM-FPU user function 0
symbol initDisplay      = 1             ' uM-FPU user function 1
symbol initGraph        = 2             ' uM-FPU user function 2
symbol clearGraph       = 3             ' uM-FPU user function 3
symbol clearPoints      = 4             ' uM-FPU user function 4
symbol storePoint       = 5             ' uM-FPU user function 5
symbol drawLineGraph    = 6             ' uM-FPU user function 6
symbol drawHistogram    = 7             ' uM-FPU user function 7
symbol drawTitle        = 8             ' uM-FPU user function 8
symbol drawXLabel       = 9             ' uM-FPU user function 9
symbol drawYLabel       = 10            ' uM-FPU user function 10
symbol drawLine         = 11            ' uM-FPU user function 11
symbol drawBox          = 12            ' uM-FPU user function 12
symbol fillBox          = 13            ' uM-FPU user function 13
symbol drawString       = 14            ' uM-FPU user function 14
symbol drawBackGround   = 15            ' uM-FPU user function 15
symbol drawXaxis        = 16            ' uM-FPU user function 16
symbol drawYaxis        = 17            ' uM-FPU user function 17
symbol graphSize        = 18            ' uM-FPU user function 18
symbol setXaxis         = 19            ' uM-FPU user function 19
symbol setYaxis         = 20            ' uM-FPU user function 20
symbol setXvalue        = 21            ' uM-FPU user function 21
symbol getX             = 22            ' uM-FPU user function 22
symbol getY             = 23            ' uM-FPU user function 23
symbol move             = 24            ' uM-FPU user function 24
symbol draw             = 25            ' uM-FPU user function 25
symbol getPoint         = 26            ' uM-FPU user function 26
symbol getXscale        = 27            ' uM-FPU user function 27
symbol getYscale        = 28            ' uM-FPU user function 28
symbol longString       = 29            ' uM-FPU user function 29
symbol timeString       = 30            ' uM-FPU user function 30
symbol floatString      = 31            ' uM-FPU user function 31
symbol freqString       = 32            ' uM-FPU user function 32
symbol piString         = 33            ' uM-FPU user function 33
symbol trim             = 34            ' uM-FPU user function 34
symbol trimNum          = 35            ' uM-FPU user function 35
symbol stringWidth      = 36            ' uM-FPU user function 36
symbol delay_ms         = 37            ' uM-FPU user function 37

'===============================================================================
'-------------------- main routine ---------------------------------------------
'===============================================================================

main:
	pause 500				' wait for terminal window
	sertxd (13, 10, "graph demo1", 13, 10)

	i2cslave fpuID, i2cfast, i2cbyte
	gosub fpu_reset			' reset the uM-FPU
	
	if statusByte = SYNC_CHAR then
	  gosub print_version		' display the uM-FPU version number
	else
	  sertxd (13, 10, "uM-FPU not detected.")
	  end
	endif

	writei2c 0, (FCALL, getID, SELECTA, 0)
	gosub fpu_wait			' check if functions are loaded
	writei2c 0, (LREADBYTE)
	readi2c 0, (dataByte)
	if dataByte <> 42 then
	  sertxd(13, 10, "App Note 42 functions not loaded")
	  end
	endif
		
	' initialize the graphic display and SEROUT pin
	writei2c 0, (FCALL, initDisplay)

	' initialize the graph and clear data array

	sertxd (13, 10, "Figure 1")
	writei2c 0, (FCALL, initGraph)
	gosub storeData
	writei2c 0, (FCALL, drawLineGraph)

  	pause 2000
	writei2c 0, (FCALL, clearGraph)

	sertxd (13, 10, "Figure 2")
	writei2c 0, (FCALL, initGraph)
	gosub sStoreData
	writei2c 0, (COPYI, $8F, formatX)
	writei2c 0, (COPYI, $8F, formatY)
	writei2c 0, (FCALL, drawLineGraph)

  	pause 2000
	writei2c 0, (FCALL, clearGraph)

	sertxd (13, 10, "Figure 4")
	writei2c 0, (FCALL, initGraph)
	gosub storeData
	writei2c 0, (COPYI, $AB, formatX)
	writei2c 0, (COPYI, $EB, formatY)
	writei2c 0, (COPYI, 30, gxWinMin)
	writei2c 0, (COPYI, 210, gxWinMax)
	writei2c 0, (COPYI, 20, gyWinMin)
	writei2c 0, (COPYI, 140, gyWinMax)
	writei2c 0, (FCALL, drawLineGraph)
	writei2c 0, (STRSET, "Line graph", 0, FCALL, drawTitle)
	writei2c 0, (STRSET, "X axis", 0, FCALL, drawXLabel)
	writei2c 0, (STRSET, "Y axis", 0, FCALL, drawYLabel)

done:
	writei2c 0, (FSEROUT, 0, 0)	' disable SEROUT 
	sertxd(13, 10, "Done.")
	end          			' end of program

storeData:
	' store points to graph
	writei2c 0, (LOADUBYTE, 0, FCALL, storePoint)
	writei2c 0, (LOADUBYTE, 10, FCALL, storePoint)
	writei2c 0, (LOADUBYTE, 5, FCALL, storePoint)
	writei2c 0, (LOADUBYTE, 25, FCALL, storePoint)
	writei2c 0, (LOADUBYTE, 12, FCALL, storePoint)
	writei2c 0, (LOADUBYTE, 22, FCALL, storePoint)
	return

'===============================================================================
'-------------------- uM-FPU V3.1 I2C support routines -------------- 2007-07-11
'===============================================================================

fpu_reset:
	writei2c 1, (0)			' reset the FPU
	pause 10				' wait for reset to complete
	
	writei2c 0, (SYNC)		' check for synchronization
	goto fpu_readStatus2

fpu_wait:
	readi2c 0, (statusByte)		' wait for ready status
	if statusByte <> 0 then fpu_wait
	return

fpu_readStatus:
	gosub fpu_wait			' read status byte
	writei2c 0, (READSTATUS)

fpu_readStatus2:
	readi2c 0, (statusByte)		' read status byte
	return

print_version:
	writei2c 0, (VERSION)		' get the FPU version string
	goto print_fpuString		' print it

print_float:
	format = 0				' set for free format
						' (fall through to print_floatFormat)
print_floatFormat:
	writei2c 0, (FTOA, format)	' convert floating point to formatted ASCII
	goto print_fpuString		' print the string

print_long:
	format = 0				' set for free format
						' (fall through to print_longFormat)
print_longFormat:
	writei2c 0, (LTOA, format)	' convert long integer to formatted ASCII
						' (fall through to print_fpuString)
print_fpuString:
	gosub fpu_wait			' wait until FPU is ready
	writei2c 0, (READSTR)

print_string:
	do		
	  readi2c 0, (dataByte)		' display zero terminated string
	  if dataByte = 0 then exit
	  sertxd(dataByte)
	loop
	return

'==================== end of uM-FPU V3.1 I2C support routines ==================










